/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.oblivioussp.spartanweaponry.enchantment.EnchantmentCrossbowRapidLoad;
import com.oblivioussp.spartanweaponry.enchantment.EnchantmentCrossbowSharpshooter;
import com.oblivioussp.spartanweaponry.enchantment.EnchantmentCrossbowSpreadshot;
import com.oblivioussp.spartanweaponry.enchantment.EnchantmentThrowingAmmo;
import com.oblivioussp.spartanweaponry.enchantment.EnchantmentThrowingCharge;
import com.oblivioussp.spartanweaponry.enchantment.EnchantmentThrowingDamage;
import com.oblivioussp.spartanweaponry.enchantment.EnchantmentThrowingFire;
import com.oblivioussp.spartanweaponry.enchantment.EnchantmentThrowingHydrodynamic;
import com.oblivioussp.spartanweaponry.enchantment.EnchantmentThrowingLuck;
import com.oblivioussp.spartanweaponry.enchantment.EnchantmentThrowingRange;
import com.oblivioussp.spartanweaponry.enchantment.EnchantmentThrowingReturn;
import com.oblivioussp.spartanweaponry.util.Log;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class EnchantmentRegistrySW {
    public static final Enchantment THROWING_RANGE = new EnchantmentThrowingRange(Enchantment.Rarity.UNCOMMON);
    public static final Enchantment THROWING_DAMAGE = new EnchantmentThrowingDamage(Enchantment.Rarity.COMMON);
    public static final Enchantment THROWING_FIRE = new EnchantmentThrowingFire(Enchantment.Rarity.RARE);
    public static final Enchantment THROWING_LUCK = new EnchantmentThrowingLuck(Enchantment.Rarity.RARE);
    public static final Enchantment THROWING_HYDRODYNAMIC = new EnchantmentThrowingHydrodynamic(Enchantment.Rarity.VERY_RARE);
    public static final Enchantment THROWING_CHARGE = new EnchantmentThrowingCharge(Enchantment.Rarity.RARE);
    public static final Enchantment THROWING_AMMO = new EnchantmentThrowingAmmo(Enchantment.Rarity.RARE);
    public static final Enchantment THROWING_RETURN = new EnchantmentThrowingReturn(Enchantment.Rarity.VERY_RARE);
    public static final Enchantment CROSSBOW_CHARGE = new EnchantmentCrossbowRapidLoad(Enchantment.Rarity.UNCOMMON);
    public static final Enchantment CROSSBOW_SPREADSHOT = new EnchantmentCrossbowSpreadshot(Enchantment.Rarity.RARE);
    public static final Enchantment CROSSBOW_SHARPSHOOTER = new EnchantmentCrossbowSharpshooter(Enchantment.Rarity.RARE);
    public static final Map<ResourceLocation, Enchantment> REMAP_VALUES = ImmutableMap.builder().put((Object)new ResourceLocation("spartanweaponry", "throwing_range"), (Object)THROWING_RANGE).put((Object)new ResourceLocation("spartanweaponry", "throwing_damage"), (Object)THROWING_DAMAGE).put((Object)new ResourceLocation("spartanweaponry", "throwing_fire"), (Object)THROWING_FIRE).put((Object)new ResourceLocation("spartanweaponry", "throwing_luck"), (Object)THROWING_LUCK).put((Object)new ResourceLocation("spartanweaponry", "throwing_charge"), (Object)THROWING_CHARGE).put((Object)new ResourceLocation("spartanweaponry", "throwing_ammo"), (Object)THROWING_AMMO).build();

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Enchantment> ev) {
        IForgeRegistry reg = ev.getRegistry();
        Log.info("Registering Enchantments!");
        reg.register((IForgeRegistryEntry)THROWING_RANGE);
        reg.register((IForgeRegistryEntry)THROWING_DAMAGE);
        reg.register((IForgeRegistryEntry)THROWING_FIRE);
        reg.register((IForgeRegistryEntry)THROWING_LUCK);
        reg.register((IForgeRegistryEntry)THROWING_HYDRODYNAMIC);
        reg.register((IForgeRegistryEntry)THROWING_CHARGE);
        reg.register((IForgeRegistryEntry)THROWING_AMMO);
        reg.register((IForgeRegistryEntry)THROWING_RETURN);
        reg.register((IForgeRegistryEntry)CROSSBOW_CHARGE);
        reg.register((IForgeRegistryEntry)CROSSBOW_SPREADSHOT);
        reg.register((IForgeRegistryEntry)CROSSBOW_SHARPSHOOTER);
    }

    @SubscribeEvent
    public static void remapToNewValues(RegistryEvent.MissingMappings<Enchantment> ev) {
        ImmutableList missingMaps = ev.getMappings();
        Log.info("Found missing enchantment mappings! Attempting to correct " + missingMaps.size() + " values!");
        missingMaps.forEach(mapping -> {
            Enchantment replacement = REMAP_VALUES.get(mapping.key);
            if (replacement != null) {
                Log.info("Remapped enchantment " + mapping.key.toString() + " to " + replacement.getRegistryName().toString());
                mapping.remap((IForgeRegistryEntry)replacement);
            }
        });
        Log.info("Remapping complete!");
    }
}

